# 🖼️ Hero Slider Image Upload - Quick Start Guide

## ⚡ 3-Step Setup

### Step 1: Verify Database (1 minute)
Open this URL in your browser while logged in as admin:
```
http://localhost/Cleaning Service/test_hero_slider_image_upload.php
```

**What to check:**
- All green ✓ marks should appear
- If any red ✗ marks, follow the on-screen instructions
- Database table should exist with `slide_image` column

### Step 2: Test Image Upload (2 minutes)
1. Go to **Admin Dashboard**
2. Click **"Hero Slider"** in the sidebar
3. Click **"Add Slide"** button
4. Fill in the form:
   - Title: `"Test Slide"`
   - Description: `"Testing image upload"`
   - Other fields: Optional

### Step 3: Upload Image (1 minute)
1. **Scroll to "Slide Image" section**
2. Either:
   - **Click** the dashed border area to select a file
   - **Drag & drop** an image file onto it
3. See the **image preview** appear
4. Click **"Save Slide"** button
5. Success! ✓

---

## 🎯 Usage Features

### Uploading Images
- **Format**: JPG, PNG, GIF, WebP
- **Max Size**: 5 MB
- **Recommended**: 1920×1080 pixels

### Drag & Drop
- Drag image directly onto the upload area
- No need to click - just drop it!

### Remove Image
- Click **"Remove Image"** button to delete preview
- Image won't be saved to database

### Edit Image
- Click edit icon on any slide
- Old image shows in preview
- Upload new image to replace it
- Save changes

---

## 📸 Where Images Are Stored

```
Cleaning Service/
└── assets/
    └── uploads/
        └── hero-slider/
            ├── slider_1234567_abc123.jpg
            ├── slider_1234568_def456.png
            └── ...
```

**Access**: Files are stored on server, not visible to public
**Cleanup**: Old images auto-deleted when updated

---

## ✅ What You Can Do

| Action | Steps |
|--------|-------|
| **Add Slide with Image** | Admin → Hero Slider → Add Slide → Upload Image → Save |
| **Edit Image** | Click edit icon → Upload new image → Save |
| **Remove Image** | Click Remove Image button → Save |
| **Delete Slide** | Click delete icon → Image auto-deleted |

---

## ❌ Common Issues & Solutions

### "Upload Failed"
- **Problem**: File too large
- **Solution**: Resize image to under 5MB

### "Invalid File Type"
- **Problem**: Wrong format
- **Solution**: Use JPG, PNG, GIF, or WebP

### "Image Not Showing"
- **Problem**: Slide not marked Active
- **Solution**: Check "Status" is set to "Active"

### "Upload Button Not Working"
- **Problem**: Not logged in as admin
- **Solution**: Login to admin panel first

---

## 📱 Mobile-Friendly

The image upload form works perfectly on:
- ✓ Desktop computers
- ✓ Tablets
- ✓ Mobile phones
- ✓ All screen sizes

---

## 🔐 Safety

- Only admins can upload
- Files are validated on upload
- Images can't contain malicious code
- Old files are automatically cleaned up

---

## 🚀 Getting Started Now

1. **Test Setup**: Visit verification page
2. **Add Your First Slide**: Use Admin Panel
3. **Upload Image**: Drag & drop or click
4. **View on Site**: Check homepage hero slider

---

## 📞 Need Help?

- **Setup Issues?** → Run `test_hero_slider_image_upload.php`
- **Upload Problems?** → Check file format and size
- **Display Issues?** → Verify slide is "Active"

---

## 📚 More Information

For detailed documentation, see:
- `HERO_SLIDER_IMAGE_UPLOAD_GUIDE.md` - Complete guide
- `HERO_SLIDER_IMAGE_UPLOAD_IMPLEMENTATION_SUMMARY.md` - Technical summary

---

**You're ready! Start uploading images for your hero slider! 🎉**
